/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.SeaSerpent;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpentBubbles;
import com.iafenvoy.iceandfire.entity.EntitySlowPart;
import com.iafenvoy.iceandfire.entity.ai.FlyingAITarget;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIGetInWater;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIJump;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIMeleeJump;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentAIRandomSwimming;
import com.iafenvoy.iceandfire.entity.ai.SeaSerpentPathNavigator;
import com.iafenvoy.iceandfire.entity.util.EntityUtil;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.util.RandomHelper;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3855;
import net.minecraft.class_3959;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_8109;
import net.minecraft.class_8111;

public class EntitySeaSerpent
extends class_1429
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final class_2940<String> VARIANT = class_2945.method_12791(EntitySeaSerpent.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Float> SCALE = class_2945.method_12791(EntitySeaSerpent.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> JUMPING = class_2945.method_12791(EntitySeaSerpent.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BREATHING = class_2945.method_12791(EntitySeaSerpent.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ANCIENT = class_2945.method_12791(EntitySeaSerpent.class, (class_2941)class_2943.field_13323);
    private final float[] tailYaw = new float[5];
    private final float[] prevTailYaw = new float[5];
    private final float[] tailPitch = new float[5];
    private final float[] prevTailPitch = new float[5];
    public int swimCycle;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float prevJumpRot = 0.0f;
    public float breathProgress = 0.0f;
    public boolean attackDecision = false;
    public int jumpCooldown = 0;
    private int animationTick;
    private Animation currentAnimation;
    private EntitySlowPart[] segments = new EntitySlowPart[9];
    private float lastScale;
    private boolean isLandNavigator;
    private boolean changedSwimBehavior = false;
    private int ticksSinceRoar = 0;
    private boolean isBreathing;

    public EntitySeaSerpent(class_1299<EntitySeaSerpent> t, class_1937 worldIn) {
        super(t, worldIn);
        this.switchNavigator(false);
        this.field_5985 = true;
        this.lastScale = 0.0f;
        this.method_5941(class_7.field_18, 0.0f);
    }

    private static class_2338 clampBlockPosToWater(class_1297 entity, class_1937 world, class_2338 pos) {
        class_2338 topY = new class_2338(pos.method_10263(), entity.method_31478(), pos.method_10260());
        class_2338 bottomY = new class_2338(pos.method_10263(), entity.method_31478(), pos.method_10260());
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.method_10264() < world.method_31600()) {
            topY = topY.method_10084();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.method_10264() > 0) {
            bottomY = bottomY.method_10074();
        }
        return new class_2338(pos.method_10263(), class_3532.method_15340((int)pos.method_10264(), (int)(bottomY.method_10264() + 1), (int)(topY.method_10264() - 1)), pos.method_10260());
    }

    public static boolean isWaterBlock(class_1937 world, class_2338 pos) {
        return world.method_8316(pos).method_15767(class_3486.field_15517);
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue())).method_26868(class_5134.field_23724, 3.0);
    }

    private static boolean canBreak(class_2248 block) {
        return block instanceof class_2302 || block instanceof class_2473 || block instanceof class_2356 || block == class_2246.field_10428 || block == class_2246.field_10588 || block == class_2246.field_10559 || block == class_2246.field_10251 || block == class_2246.field_9974 || block == class_2246.field_10214;
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SeaSerpentAIGetInWater(this));
        this.field_6201.method_6277(1, (class_1352)new SeaSerpentAIMeleeJump(this));
        this.field_6201.method_6277(1, (class_1352)new SeaSerpentAIAttackMelee(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new SeaSerpentAIRandomSwimming((class_1314)this, 1.0, 2));
        this.field_6201.method_6277(3, (class_1352)new SeaSerpentAIJump(this, 4));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{EntityMultipartPart.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, new FlyingAITarget<class_1309>((class_1308)this, class_1309.class, 150, false, false, entity1 -> !(entity1 instanceof EntitySeaSerpent) && DragonUtils.isAlive(entity1) && entity1.method_5816()));
        this.field_6185.method_6277(3, new FlyingAITarget<class_1657>((class_1308)this, class_1657.class, 0, false, false, entity -> !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive(entity)));
    }

    public int method_6110() {
        return this.isAncient() ? 30 : 15;
    }

    public void method_6070() {
        List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityMultipartPart) && entity.method_5810()).forEach(entity -> entity.method_5697((class_1297)this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new class_1409((class_1308)this, this.method_37908());
            this.field_6189.method_6354(true);
            this.isLandNavigator = true;
        } else {
            this.field_6207 = new SwimmingMoveHelper(this);
            this.field_6189 = new SeaSerpentPathNavigator((class_1308)this, this.method_37908());
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(class_2338 pos) {
        class_243 vector3d = new class_243(this.method_23317(), this.method_23320(), this.method_23321());
        class_243 bector3d1 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        return this.method_37908().method_17742(new class_3959(vector3d, bector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue()).doubleValue());
        this.method_5996(class_5134.field_23717).method_6192((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
        this.updateAttributes();
    }

    public void updateScale(float scale) {
        this.segments = new EntitySlowPart[9];
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null || this.segments[i].method_31481()) {
                this.segments[i] = i > 3 ? new EntitySlowPart((class_1297)this, 0.5f * (float)(i - 3), 180.0f, 0.0f, 0.5f, 0.5f, 1.0f) : new EntitySlowPart((class_1297)this, -0.4f * (float)(i + 1), 180.0f, 0.0f, 0.45f, 0.4f, 1.0f);
                this.method_37908().method_8649((class_1297)this.segments[i]);
            }
            this.segments[i].updateScale(scale);
        }
    }

    public void onUpdateParts() {
        if (this.method_31481()) {
            return;
        }
        for (EntitySlowPart entity : this.segments) {
            entity.method_5719((class_1297)this);
            EntityUtil.updatePart(entity, (class_1309)this);
        }
    }

    private void removeParts() {
        for (EntitySlowPart entity : this.segments) {
            if (entity == null) continue;
            entity.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.removeParts();
        super.method_5650(reason);
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return this.method_5864().method_18386().method_18383(this.method_17825());
    }

    public float method_17825() {
        return this.getSeaSerpentScale();
    }

    public void method_18382() {
        super.method_18382();
        float scale = this.getSeaSerpentScale();
        if (scale != this.lastScale) {
            this.updateScale(this.getSeaSerpentScale());
        }
        this.lastScale = scale;
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.method_18382();
        this.onUpdateParts();
        if (this.method_5799()) {
            this.spawnParticlesAroundEntity((class_1297)this, (int)this.getSeaSerpentScale());
        }
        if (!this.method_37908().field_9236 && this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.method_5968() != null && !this.method_5968().method_5805()) {
            this.method_5980(null);
        }
        System.arraycopy(this.tailYaw, 0, this.prevTailYaw, 0, this.tailYaw.length);
        System.arraycopy(this.tailPitch, 0, this.prevTailPitch, 0, this.tailPitch.length);
        this.tailYaw[0] = this.field_6283;
        this.tailPitch[0] = this.method_36455();
        System.arraycopy(this.prevTailYaw, 0, this.tailYaw, 1, this.tailYaw.length - 1);
        System.arraycopy(this.prevTailPitch, 0, this.tailPitch, 1, this.tailPitch.length - 1);
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
        this.method_5855(this.method_5748());
    }

    public float getPieceYaw(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailYaw[index] + (this.tailYaw[index] - this.prevTailYaw[index]) * partialTicks;
        }
        return 0.0f;
    }

    public float getPiecePitch(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailPitch[index] + (this.tailPitch[index] - this.prevTailPitch[index]) * partialTicks;
        }
        return 0.0f;
    }

    private void spawnParticlesAroundEntity(class_1297 entity, int count) {
        for (int i = 0; i < count; ++i) {
            int x = (int)Math.round(entity.method_23317() + (double)(this.field_5974.method_43057() * entity.method_17681() * 2.0f) - (double)entity.method_17681());
            int y = (int)Math.round(entity.method_23318() + 0.5 + (double)(this.field_5974.method_43057() * entity.method_17682()));
            int z = (int)Math.round(entity.method_23321() + (double)(this.field_5974.method_43057() * entity.method_17681() * 2.0f) - (double)entity.method_17681());
            if (!this.method_37908().method_8320(new class_2338(x, y, z)).method_27852(class_2246.field_10382)) continue;
            this.method_37908().method_8406((class_2394)class_2398.field_11247, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    private void spawnSlamParticles() {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 5; ++i1) {
                double motionX = this.method_6051().method_43059() * 0.07;
                double motionY = this.method_6051().method_43059() * 0.07;
                double motionZ = this.method_6051().method_43059() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.field_6283 + (float)i1 * 1.0f;
                double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * class_3532.method_15362((float)angle);
                if (!this.method_37908().field_9236) continue;
                this.method_37908().method_8466((class_2394)class_2398.field_11247, true, this.method_23317() + extraX, this.method_23318() + extraY, this.method_23321() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)SeaSerpent.BLUE.getName());
        this.field_6011.method_12784(SCALE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(JUMPING, (Object)false);
        this.field_6011.method_12784(BREATHING, (Object)false);
        this.field_6011.method_12784(ANCIENT, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Variant", this.getVariant());
        compound.method_10569("TicksSinceRoar", this.ticksSinceRoar);
        compound.method_10569("JumpCooldown", this.jumpCooldown);
        compound.method_10548("Scale", this.getSeaSerpentScale());
        compound.method_10556("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.method_10556("AttackDecision", this.attackDecision);
        compound.method_10556("Breathing", this.isBreathing());
        compound.method_10556("Ancient", this.isAncient());
        this.removeParts();
        this.lastScale = 0.0f;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Variant") && compound.method_10580("Variant").method_10711() == 8) {
            this.setVariant(compound.method_10558("Variant"));
        } else {
            this.setVariant(SeaSerpent.values().get(compound.method_10550("Variant")).getName());
        }
        this.ticksSinceRoar = compound.method_10550("TicksSinceRoar");
        this.jumpCooldown = compound.method_10550("JumpCooldown");
        this.setSeaSerpentScale(compound.method_10583("Scale"));
        this.setJumpingOutOfWater(compound.method_10577("JumpingOutOfWater"));
        this.attackDecision = compound.method_10577("AttackDecision");
        this.setBreathing(compound.method_10577("Breathing"));
        this.setAncient(compound.method_10577("Ancient"));
        this.setConfigurableAttributes();
    }

    private void updateAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.method_5996(class_5134.field_23721).method_6192(Math.max(4.0, (Double)IafCommonConfig.INSTANCE.seaSerpent.attackDamage.getValue() * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.method_5996(class_5134.field_23716).method_6192(Math.max(10.0, (Double)IafCommonConfig.INSTANCE.seaSerpent.baseHealth.getValue() * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.method_5996(class_5134.field_23717).method_6192((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
        this.method_6025(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        float scale = ((Float)this.field_6011.method_12789(SCALE)).floatValue();
        if (scale == 0.0f) {
            scale = (float)RandomHelper.nextDouble((double)1.0, (double)5.0);
            this.setSeaSerpentScale(scale);
        }
        return scale;
    }

    private void setSeaSerpentScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
    }

    public String getVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.field_6011.method_12789(JUMPING);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.field_6011.method_12778(JUMPING, (Object)jump);
    }

    public boolean isAncient() {
        return (Boolean)this.field_6011.method_12789(ANCIENT);
    }

    public void setAncient(boolean ancient) {
        this.field_6011.method_12778(ANCIENT, (Object)ancient);
    }

    public boolean isBreathing() {
        if (this.method_37908().field_9236) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.field_6011.method_12789(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setBreathing(boolean breathing) {
        this.field_6011.method_12778(BREATHING, (Object)breathing);
        if (!this.method_37908().field_9236) {
            this.isBreathing = breathing;
        }
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public void method_6007() {
        class_1297 class_12972;
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.method_5799() && !this.method_24828() && this.method_18798().field_1351 >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.method_5799() && this.method_24828();
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.jumpCooldown;
        this.prevJumpRot = this.jumpRot;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.method_5783((class_3414)IafSounds.SEA_SERPENT_ROAR.get(), this.method_6107() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.method_5783((class_3414)IafSounds.SEA_SERPENT_BITE.get(), this.method_6107(), 1.0f);
        }
        if (this.isJumpingOutOfWater() && EntitySeaSerpent.isWaterBlock(this.method_37908(), this.method_24515().method_10086(2))) {
            this.setJumpingOutOfWater(false);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping && !this.isJumpingOutOfWater()) {
            this.method_5783((class_3414)IafSounds.SEA_SERPENT_SPLASH.get(), 5.0f, 0.75f);
            this.spawnSlamParticles();
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.method_36457(class_3532.method_15363((float)((float)this.method_18798().field_1351 * 20.0f), (float)-90.0f, (float)90.0f));
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.method_37908().field_9236) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.method_5968() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.method_5968().method_5799() || !this.method_6057((class_1297)this.method_5968()) || this.method_5739((class_1297)this.method_5968()) < 30.0f * this.getSeaSerpentScale()) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.method_5968());
                    }
                } else if (this.method_5858((class_1297)this.method_5968()) > (double)(200.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.method_5968() != null && (this.isTouchingMob((class_1297)this.method_5968()) || this.method_5858((class_1297)this.method_5968()) < 50.0)) {
            this.hurtMob(this.method_5968());
        }
        this.breakBlock();
        if (!this.method_37908().field_9236 && this.method_5765() && (class_12972 = this.method_5668()) instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            boat.method_5650(class_1297.class_5529.field_26998);
            this.method_5848();
        }
    }

    private boolean isAtSurface() {
        class_2338 pos = this.method_24515();
        return EntitySeaSerpent.isWaterBlock(this.method_37908(), pos.method_10074()) && !EntitySeaSerpent.isWaterBlock(this.method_37908(), pos.method_10084());
    }

    private void doSplashDamage() {
        double getWidth = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009(getWidth, getWidth * 0.5, getWidth), entity -> {
            if (!(entity instanceof class_1309)) return false;
            class_1309 living = (class_1309)entity;
            if (entity instanceof EntitySeaSerpent) return false;
            if (!DragonUtils.isAlive(living)) return false;
            return true;
        });
        for (class_1297 entity2 : list) {
            if (!(entity2 instanceof class_1309) || !DragonUtils.isAlive((class_1309)entity2)) continue;
            entity2.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            this.destroyBoat(entity2);
            double xRatio = this.method_23317() - entity2.method_23317();
            double zRatio = this.method_23321() - entity2.method_23321();
            float f = class_3532.method_15355((float)((float)(xRatio * xRatio + zRatio * zRatio)));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity2.method_18799(entity2.method_18798().method_18805(0.5, 1.0, 0.5));
            entity2.method_18799(entity2.method_18798().method_1031(xRatio / (double)f * (double)strength, (double)strength, zRatio / (double)f * (double)strength));
        }
    }

    public void destroyBoat(class_1297 sailor) {
        class_1297 class_12972;
        if (sailor.method_5854() != null && (class_12972 = sailor.method_5854()) instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            if (!this.method_37908().field_9236) {
                boat.method_5650(class_1297.class_5529.field_26998);
                if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                    for (int i = 0; i < 3; ++i) {
                        boat.method_5699(new class_1799((class_1935)boat.method_47885().method_7560().method_8389()), 0.0f);
                    }
                    for (int j = 0; j < 2; ++j) {
                        boat.method_5775(new class_1799((class_1935)class_1802.field_8600));
                    }
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.method_5968() != null) {
            class_2338 pos = this.method_5968().method_24515();
            return !EntitySeaSerpent.isWaterBlock(this.method_37908(), pos.method_10086((int)Math.ceil(this.method_5968().method_17682())));
        }
        return false;
    }

    private void hurtMob(class_1309 entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() == 6) {
            this.method_5968().method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
            this.attackDecision = this.method_6051().method_43056();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
        double z = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
        float f = class_3532.method_15355((float)((float)(x * x + z * z)));
        x /= (double)f;
        z /= (double)f;
        this.method_18800(x *= (double)velocity, this.method_18798().field_1351, z *= (double)velocity);
    }

    public boolean isTouchingMob(class_1297 entity) {
        if (this.method_5829().method_1012(1.0, 1.0, 1.0).method_994(entity.method_5829())) {
            return true;
        }
        for (EntitySlowPart segment : this.segments) {
            if (segment == null || !segment.method_5829().method_1012(1.0, 1.0, 1.0).method_994(entity.method_5829())) continue;
            return true;
        }
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public void breakBlock() {
        if (((Boolean)IafCommonConfig.INSTANCE.seaSerpent.griefing.getValue()).booleanValue()) {
            for (int a = (int)Math.round(this.method_5829().field_1323) - 2; a <= (int)Math.round(this.method_5829().field_1320) + 2; ++a) {
                for (int b = (int)Math.round(this.method_5829().field_1322) - 1; b <= (int)Math.round(this.method_5829().field_1325) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.method_5829().field_1321) - 2; c <= (int)Math.round(this.method_5829().field_1324) + 2; ++c) {
                        class_2338 pos = new class_2338(a, b, c);
                        class_2680 state = this.method_37908().method_8320(pos);
                        class_3610 fluidState = this.method_37908().method_8316(pos);
                        class_2248 block = state.method_26204();
                        if (state.method_26215() || state.method_26218((class_1922)this.method_37908(), pos).method_1110() || !EntitySeaSerpent.canBreak(state.method_26204()) && !(state.method_26204() instanceof class_2397) || !fluidState.method_15769() || block == class_2246.field_10124 || this.method_37908().field_9236) continue;
                        this.method_37908().method_22352(pos, true);
                    }
                }
            }
        }
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        boolean ancient;
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(((SeaSerpent)RandomHelper.randomOne(SeaSerpent.values())).getName());
        boolean bl = ancient = this.method_6051().method_43048(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.method_6051().method_43057() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.method_6051().method_43057() * 4.0f);
        }
        this.updateAttributes();
        return spawnDataIn;
    }

    public void onWorldSpawn(class_5819 random) {
        boolean ancient;
        this.setVariant(((SeaSerpent)RandomHelper.randomOne(SeaSerpent.values())).getName());
        boolean bl = ancient = random.method_43048(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.method_43057() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.method_43057() * 4.0f);
        }
        this.updateAttributes();
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    protected class_3414 method_5994() {
        return (class_3414)IafSounds.SEA_SERPENT_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)IafSounds.SEA_SERPENT_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)IafSounds.SEA_SERPENT_DIE.get();
    }

    public void method_5966() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_5966();
    }

    protected void method_6013(class_1282 source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.method_6013(source);
    }

    @Override
    public boolean shouldAnimalsFear(class_1297 entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.field_6012 % 50 > 43;
    }

    private void shoot(class_1309 entity) {
        if (!this.attackDecision) {
            if (!this.method_5799()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.field_6012 % 40 == 0) {
                    this.method_5783((class_3414)IafSounds.SEA_SERPENT_BREATH.get(), 4.0f, 1.0f);
                }
                if (this.field_6012 % 10 == 0) {
                    this.method_36456(this.field_6283);
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].method_23317() + (double)(1.3f * this.getSeaSerpentScale() * class_3532.method_15362((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
                    float headPosZ = f2 + (float)(this.segments[0].method_23321() + (double)(1.3f * this.getSeaSerpentScale() * class_3532.method_15374((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
                    float headPosY = f3 + (float)(this.segments[0].method_23318() + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.method_23317() - (double)headPosX;
                    double d3 = entity.method_23318() - (double)headPosY;
                    double d4 = entity.method_23321() - (double)headPosZ;
                    float inaccuracy = 1.0f;
                    EntitySeaSerpentBubbles entitylargefireball = new EntitySeaSerpentBubbles((class_1299<? extends class_3855>)((class_1299)IafEntities.SEA_SERPENT_BUBBLES.get()), this.method_37908(), this, d2 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d3 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, d4 += this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.method_5814(headPosX, headPosY, headPosZ);
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)entitylargefireball);
                    }
                    if (!entity.method_5805()) {
                        this.setBreathing(false);
                        this.attackDecision = this.method_6051().method_43056();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.method_5951((class_1297)entity, 360.0f, 360.0f);
    }

    public SeaSerpent getEnum() {
        return SeaSerpent.getByName(this.getVariant());
    }

    public void method_6091(class_243 vec) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), vec);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(vec);
        }
    }

    public boolean method_5874(class_3218 world, class_1309 entity) {
        this.attackDecision = this.method_6051().method_43056();
        return this.attackDecision;
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public int method_5850() {
        return 1000;
    }

    public boolean shouldUseJumpAttack(class_1309 attackTarget) {
        return !attackTarget.method_5799() || this.isPreyAtSurface();
    }

    public boolean method_5679(class_1282 source) {
        class_8109 damageSources = this.method_37908().method_48963();
        return source == damageSources.method_48827() || source == damageSources.method_48824() || source == damageSources.method_48822() || source.method_5529() != null && source == damageSources.method_48798(source.method_5529()) || source == damageSources.method_48817() || source.method_49708(class_8111.field_42335) || super.method_5679(source);
    }

    public static class SwimmingMoveHelper
    extends class_1335 {
        private final EntitySeaSerpent dolphin;

        public SwimmingMoveHelper(EntitySeaSerpent dolphinIn) {
            super((class_1308)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void method_6240() {
            if (this.dolphin.method_5799()) {
                this.dolphin.method_18799(this.dolphin.method_18798().method_1031(0.0, 0.005, 0.0));
            }
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.dolphin.method_5942().method_6357()) {
                double d2;
                double d1;
                double d0 = this.field_6370 - this.dolphin.method_23317();
                double d3 = d0 * d0 + (d1 = this.field_6369 - this.dolphin.method_23318()) * d1 + (d2 = this.field_6367 - this.dolphin.method_23321()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_6371.method_5930(0.0f);
                } else {
                    float f = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.method_36456(this.method_6238(this.dolphin.method_36454(), f, 10.0f));
                    this.dolphin.field_6283 = this.dolphin.method_36454();
                    this.dolphin.field_6241 = this.dolphin.method_36454();
                    float f1 = (float)(this.field_6372 * 3.0);
                    if (this.dolphin.method_5799()) {
                        this.dolphin.method_6125(f1 * 0.02f);
                        float f2 = -((float)(class_3532.method_15349((double)d1, (double)class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = class_3532.method_15363((float)class_3532.method_15393((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.method_18799(this.dolphin.method_18798().method_1031(0.0, (double)this.dolphin.method_6029() * d1 * 0.6, 0.0));
                        this.dolphin.method_36457(this.method_6238(this.dolphin.method_36455(), f2, 1.0f));
                        float f3 = class_3532.method_15362((float)(this.dolphin.method_36455() * ((float)Math.PI / 180)));
                        float f4 = class_3532.method_15374((float)(this.dolphin.method_36455() * ((float)Math.PI / 180)));
                        this.dolphin.field_6250 = f3 * f1;
                        this.dolphin.field_6227 = -f4 * f1;
                    } else {
                        this.dolphin.method_6125(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.method_6125(0.0f);
                this.dolphin.method_5938(0.0f);
                this.dolphin.method_5976(0.0f);
                this.dolphin.method_5930(0.0f);
            }
        }
    }
}

